<#ibiztemplate>
TARGET=PSSYSSERVICEAPI
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${item.codeName?lower_case};

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.cloud.openfeign.EnableFeignClients;
import java.util.List;

@Slf4j
@EnableDiscoveryClient
@Configuration
@EnableTransactionManagement
@ComponentScan(basePackages = {"${pub.getPKGCodeName()}"})
@EnableMongoRepositories(basePackages = {"${pub.getPKGCodeName()}"})
@MapperScan("${pub.getPKGCodeName()}.*.mapper")
@SpringBootApplication(exclude = {
        org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration.class,
        <#assign bmogo=false>
        <#if item.getPSDEServiceAPIs()??>
        <#list item.getPSDEServiceAPIs() as api>
            <#if api.getPSDataEntity()?? && api.getPSDataEntity().getStorageMode()?? && api.getPSDataEntity().getStorageMode()==2>
                <#assign bmogo=true>
                <#break >
            </#if>
        </#list>
        </#if>
        <#if bmogo==false>
            org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration.class,
        </#if>
})
@EnableFeignClients(basePackages = {"${pub.getPKGCodeName()}" })
public class ${sys.codeName}${item.codeName}Application extends WebMvcConfigurerAdapter{

    public static void main(String[] args) {
        SpringApplication.run(${sys.codeName}${item.codeName}Application.class, args);
    }

    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
        argumentResolvers.add(new ${pub.getPKGCodeName()}.util.web.SearchContextHandlerMethodArgumentResolver());
    }
}
